/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.chat.LoggedChatEvent;

public class ChatLog {
    private final LoggedChatEvent[] buffer;
    private int nextId;

    public static Codec<ChatLog> codec(int p_253922_) {
        return Codec.list(LoggedChatEvent.CODEC).comapFlatMap(p_274704_ -> {
            int $$2 = p_274704_.size();
            if ($$2 > p_253922_) {
                return DataResult.error(() -> "Expected: a buffer of size less than or equal to " + p_253922_ + " but: " + $$2 + " is greater than " + p_253922_);
            }
            return DataResult.success((Object)new ChatLog(p_253922_, (List<LoggedChatEvent>)p_274704_));
        }, ChatLog::loggedChatEvents);
    }

    public ChatLog(int p_251403_) {
        this.buffer = new LoggedChatEvent[p_251403_];
    }

    private ChatLog(int p_254212_, List<LoggedChatEvent> p_253624_) {
        this.buffer = (LoggedChatEvent[])p_253624_.toArray(p_253908_ -> new LoggedChatEvent[p_254212_]);
        this.nextId = p_253624_.size();
    }

    private List<LoggedChatEvent> loggedChatEvents() {
        ArrayList<LoggedChatEvent> $$0 = new ArrayList<LoggedChatEvent>(this.size());
        for (int $$1 = this.start(); $$1 <= this.end(); ++$$1) {
            $$0.add(this.lookup($$1));
        }
        return $$0;
    }

    public void push(LoggedChatEvent p_242319_) {
        this.buffer[this.index((int)this.nextId++)] = p_242319_;
    }

    @Nullable
    public LoggedChatEvent lookup(int p_239050_) {
        return p_239050_ >= this.start() && p_239050_ <= this.end() ? this.buffer[this.index(p_239050_)] : null;
    }

    private int index(int p_249044_) {
        return p_249044_ % this.buffer.length;
    }

    public int start() {
        return Math.max(this.nextId - this.buffer.length, 0);
    }

    public int end() {
        return this.nextId - 1;
    }

    private int size() {
        return this.end() - this.start() + 1;
    }
}

